<?php
declare(strict_types=1);

namespace App\Controllers\User;

use App\Core\Controller;
use App\Core\Session;

final class LoginController extends Controller
{
    public function index(): void
    {
        $this->view('login', [
            'title' => 'User Login (demo)',
        ]);
    }

    public function submit(): void
    {
        Session::regenerate();
        Session::set('user_id', 10);
        \App\Core\redirect('/user/profile');
    }
}
