<?php
declare(strict_types=1);

namespace App\Core;

abstract class Controller
{
    protected string $area = 'front';
    protected Request $request;

    public function __construct(Request $request, string $area)
    {
        $this->request = $request;
        $this->area = $area;
    }

    final protected function view(string $path, array $data = []): void
    {
        View::render($this->area, $path, $data);
    }

    final protected function json($data, int $status = 200): void
    {
        Response::json($data, $status);
    }
}
