<?php
declare(strict_types=1);

namespace App\Core;

use PDO;

final class DB
{
    private static ?PDO $pdo = null;

    public static function pdo(): PDO
    {
        if (self::$pdo) {
            return self::$pdo;
        }

        $driver = Config::get('database.driver', 'mysql');
        $host = Config::get('database.host', '127.0.0.1');
        $port = (int)Config::get('database.port', 3306);
        $db = Config::get('database.name', '');
        $user = Config::get('database.user', '');
        $pass = Config::get('database.pass', '');
        $charset = Config::get('database.charset', 'utf8mb4');

        if ($driver === 'mysql') {
            $dsn = "mysql:host={$host};port={$port};dbname={$db};charset={$charset}";
        } else {
            throw new \RuntimeException('DB driver no soportado: ' . $driver);
        }

        self::$pdo = new PDO($dsn, $user, $pass, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]);

        return self::$pdo;
    }
}
