<?php
declare(strict_types=1);

namespace App\Core;

final class Router
{
    /**
     * Resuelve la URL a: area, controllerClass, method, params
     */
    public function resolve(Request $req): array
    {
        $segments = $req->segments();
        $area = 'front';

        // Áreas reservadas
        $reserved = ['admin', 'user', 'api'];
        if (!empty($segments) && in_array(strtolower($segments[0]), $reserved, true)) {
            $area = strtolower(array_shift($segments));
        }

        // Base controller dir/class prefix
        $controllerDir = APP_PATH . '/Controllers';
        $ns = 'App\\Controllers\\';
        if ($area !== 'front') {
            $controllerDir .= '/' . ucfirst($area);
            $ns .= ucfirst($area) . '\\';
        }

        // Soporta subcarpetas: /admin/settings/currencies => Admin/Settings/CurrenciesController
        $subParts = [];
        while (!empty($segments)) {
            $candidate = ucfirst($segments[0]);
            $candidateDir = $controllerDir . '/' . $candidate;
            if (is_dir($candidateDir)) {
                $subParts[] = $candidate;
                $controllerDir = $candidateDir;
                $ns .= $candidate . '\\';
                array_shift($segments);
                continue;
            }
            break;
        }

        // Controller
        $controllerName = ucfirst($segments[0] ?? 'Index') . 'Controller';
        array_shift($segments);

        $controllerFile = $controllerDir . '/' . $controllerName . '.php';
        $controllerClass = $ns . $controllerName;

        // Method + params (soporta /currencies/1/edit)
        $method = 'index';
        $params = [];

        if (!empty($segments)) {
            if (is_numeric($segments[0]) && isset($segments[1])) {
                $method = $segments[1];
                $params = [ $segments[0], *array_slice($segments, 2) ];
            } else {
                $method = $segments[0];
                $params = array_slice($segments, 1);
            }
        }

        return [
            'area' => $area,
            'controller_file' => $controllerFile,
            'controller_class' => $controllerClass,
            'method' => $method,
            'params' => $params,
        ];
    }
}
