<?php
declare(strict_types=1);

namespace App\Core;

final class View
{
    public static function render(string $area, string $view, array $data = []): void
    {
        $area = strtolower($area);
        $layout = APP_PATH . "/Views/{$area}/layout.php";
        $viewFile = APP_PATH . "/Views/{$area}/" . ltrim($view, '/') . '.php';

        if (!is_file($layout) || !is_file($viewFile)) {
            http_response_code(404);
            $notFound = APP_PATH . '/Views/errors/404.php';
            if (is_file($notFound)) {
                require $notFound;
                return;
            }
            echo '404 - Not Found';
            return;
        }

        // Data -> variables
        extract($data, EXTR_SKIP);

        // Render con layout (el layout incluye $viewFile)
        require $layout;
    }
}
