<?php
declare(strict_types=1);

namespace App\Core;

function env(string $key, $default = null) {
    return Env::get($key, $default);
}

function config(string $key, $default = null) {
    return Config::get($key, $default);
}

function redirect(string $to, int $status = 302): void {
    http_response_code($status);
    header('Location: ' . $to);
    exit;
}
