# Arquitectura (Contrato del framework)

## 1) Áreas
- Front: cualquier URL que NO empiece con `admin`, `user`, `api`.
- Admin: `/admin/*` (requiere sesión admin)
- User: `/user/*` (requiere sesión user)
- Api: `/api/*` (público por defecto)

## 2) Controllers
- Front: `app/Controllers/*.php` (sin carpeta Front)
- Admin: `app/Controllers/Admin/*`
- User: `app/Controllers/User/*`
- Api: `app/Controllers/Api/*`

### Convención
- Clase: `XxxController`
- Método: `index` por defecto
- Subcarpetas ilimitadas: `/admin/settings/currencies` => `Controllers/Admin/Settings/CurrenciesController`

## 3) Vistas
Vistas modulares por área:
- `app/Views/front/layout.php`
- `app/Views/admin/layout.php`
- `app/Views/user/layout.php`

Cada área tiene `partials/` propio.

## 4) Seguridad
- Admin y User: protegidos por sesión (Auth::requireAdmin/User)
- Login/Logout: rutas públicas dentro de su área

## 5) Config + ENV
- `.env` contiene secretos/valores por entorno y NO se sube.
- `config/*.php` define estructura y defaults (sin secretos).

## 6) Regla de oro
`index.php` no debe cambiar al agregar módulos.
